                               D   H T M L   G O O G L E _ M A P S _ H T M L       0         <!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">

<html>
<head>
  <title>
	Google Maps
  </title>
  <script src="http://maps.google.com/maps?file=api&amp;v=2.x&amp;key=ABQIAAAA3g2qJq0jZTZfTe4k7KOiJRSVMgWJOw7D2AUdbsNQUJ-uuzukgBQeOxN_Yo0Qw3LlJgtmMAf4d2V6rQ" type="text/javascript"></script>
  <style type="text/css">
  html, body { border: 0px; margin: 0px; padding: 0px; }
  </style>
  <script type="text/javascript">
  //<![CDATA[
  var map;
  var smallcontrol = new GSmallMapControl();
  var largecontrol = new GLargeMapControl();
  var loaded       = false;
  window.onload    = function()
  {
	loaded=true;
	load_map("mymap", 52, 5, 13);
  };

  var reasons=[];
	  reasons[G_GEO_SUCCESS]            = "Success";
	  reasons[G_GEO_MISSING_ADDRESS]    = "Missing Address: The address was either missing or had no value.";
	  reasons[G_GEO_UNKNOWN_ADDRESS]    = "Unknown Address:  No corresponding geographic location could be found for the specified address.";
	  reasons[G_GEO_UNAVAILABLE_ADDRESS]= "Unavailable Address:  The geocode for the given address cannot be returned due to legal or contractual reasons.";
	  reasons[G_GEO_BAD_KEY]            = "Bad Key: The API key is either invalid or does not match the domain for which it was given";
	  reasons[G_GEO_TOO_MANY_QUERIES]   = "Too Many Queries: The daily geocoding quota for this site has been exceeded.";
	  reasons[G_GEO_SERVER_ERROR]       = "Server error: The geocoding request could not be successfully processed.";
	  reasons[G_GEO_BAD_REQUEST]        = "A directions request could not be successfully parsed.";
	  reasons[G_GEO_MISSING_QUERY]      = "No query was specified in the input.";
	  reasons[G_GEO_UNKNOWN_DIRECTIONS] = "The GDirections object could not compute directions between the points.";

  var gdir=new GDirections(null, document.getElementById("path"));

  GEvent.addListener(gdir,"error", function()
  {
	var code = gdir.getStatus().code;
	var reason="Code "+code;
	if (reasons[code]) {
	  reason = "Code "+code +" : "+reasons[code]
	}
	alert("Falha ao obter rota, "+reason);
  });

  var poly;
  GEvent.addListener(gdir, "load", function()
  {
	if (poly) map.removeOverlay(poly);
	poly = gdir.getPolyline();
	map.addOverlay(poly);
	map.setZoom(map.getBoundsZoomLevel(gdir.getBounds()));
	map.setCenter(gdir.getBounds().getCenter());
  });


  // Initializes parameters and calls GDirections function
  function directions()
  {
	var start = "Start@" + start_marker.getPoint().toUrlValue(6);
	var end = "End@" + end_marker.getPoint().toUrlValue(6);
	var a = "from: "+start + " to: " + end;
	gdir.load(a, {getPolyline:true});
  }

  // ====== Create a Client Geocoder ======
  var geo = new GClientGeocoder();

  // ====== Geocoding ======
  function showAddress(search)
  {
	// ====== Perform the Geocoding ======
	geo.getLocations(search, function (result)
	{
 //       map.clearOverlays();
		var tabZoom = new Array(2,4,6,10,12,13,16,16,17);
		if (place_marker) map.removeOverlay(place_marker);
		if (result.Status.code == G_GEO_SUCCESS) {
		  // ===== If there was more than one result, "ask did you mean" on them all =====
		  if (result.Placemark.length > 1) {
			document.getElementById("path").innerHTML = "Did you mean:";
			// Loop through the results
			for (var i=0; i < result.Placemark.length; i++) {
			  var p = result.Placemark[i].Point.coordinates;
			  var zoom_level = tabZoom[result.Placemark[i].AddressDetails.Accuracy];
			  document.getElementById("path").innerHTML += "<br>"+(i+1)+": <a href='javascript:place(" +p[1]+","+p[0]+","+zoom_level+")'>"+ result.Placemark[i].address+"</a>";
		   }
		 }
		  // ===== If there was a single result =====
		  else {
			document.getElementById("path").innerHTML = "";
			var p = result.Placemark[0].Point.coordinates;
			var zoom_level = tabZoom[result.Placemark[0].AddressDetails.Accuracy];
			place(p[1],p[0],zoom_level);
		  }
		}
		// ====== Decode the error status ======
		else {
		  var reason="Code "+result.Status.code;
		  if (reasons[result.Status.code]) {
			reason = reasons[result.Status.code]
		  }
		  alert('Could not find "'+search+ '" ' + reason);
		}
	  }
	);
  }

  var place_marker;

  // ====== Plot a marker after positive reponse to "did you mean" ======
  function place(lat,lng,zoom)
  {
	var point = new GLatLng(lat,lng);
	map.setCenter(point,zoom);
	place_marker=new GMarker(point, {icon: new GIcon(G_DEFAULT_ICON, "http://sorocabaemmapas.googlepages.com/Arrow.png")});
	map.addOverlay(place_marker);
	document.getElementById("path").innerHTML = "";
  }

  // Swap Start and End markers
  function swap() {
	var start_pt = start_marker.getPoint();
	start_marker.setPoint(end_marker.getPoint());
	end_marker.setPoint(start_pt);
	if (poly) map.removeOverlay(poly);
  }

  // Switch between none, small and large zoom control
  function addControl(ctrlType) {
	switch(ctrlType)
	{
	case 1:
	  map.removeControl(largecontrol);
	  map.removeControl(smallcontrol);
	  break
	case 2:
	  map.removeControl(largecontrol);
	  map.addControl(smallcontrol)
	  break
	case 3:
	  map.removeControl(smallcontrol);
	  map.addControl(largecontrol);
	  break
	}
  }

  // Switch between normal, satellite, hybrid and physical map types
  function setMapType(mapType) {
	switch(mapType)
	{
	case 1:
	  map.setMapType(G_NORMAL_MAP);
	  break
	case 2:
	  map.setMapType(G_SATELLITE_MAP);
	  break
	case 3:
	  map.setMapType(G_HYBRID_MAP);
	  break
	case 4:
	  map.setMapType(G_PHYSICAL_MAP);
	  break
	}
  }

  var start_marker;
  var end_marker;

  // Creates a marker
  function createMarker(lat,lng)
  {
	if(!map) return;
	marker = new GMarker(new GLatLng(lat,lng), {icon: G_START_ICON, draggable: false});
	map.addOverlay(marker);
  }


  // Creates Start marker on center of the visible map
  function createStartMarker()
  {
	start_marker = new GMarker(new GLatLng(map.getCenter().lat(), map.getCenter().lng()), {icon: G_START_ICON, draggable: true});
	map.addOverlay(start_marker);
  }

  // Creates End marker on center of the visible map
  function createEndMarker()
  {
	end_marker = new GMarker(new GLatLng(map.getCenter().lat(), map.getCenter().lng()), {icon: G_END_ICON, draggable: true});
	map.addOverlay(end_marker);
  }

  // Brings marker passed by "marker" parameter to center of the visible map
  function centerMarker(marker)
  {
	marker.setPoint(new GLatLng(map.getCenter().lat(), map.getCenter().lng()));
  }


  function createMapMarker(lat, lng, html)
  {
	var point = new GLatLng(parseFloat(lat),parseFloat(lng));
	var marker = new GMarker(point);
	GEvent.addListener(marker, "click", function()
	{
	  marker.openInfoWindow(html);
	});
	map.addOverlay(marker);
	return marker;
  }

  // Controls resizement of the map window
  if (window.attachEvent)
  {
	window.attachEvent("onresize",function()
	{ //IE
	  var hght=document.getElementById("mymap").offsetWidth*0.75;
	  document.getElementById("mymap").style.height=hght+"px";
	  document.getElementById("path").style.top=hght+1+"px";
	});
  }
  else
  {
	document.getElementById("map").style.height="75%";
  }


  //prevent page scroll
  function wheelevent(e) {
	if (!e){
	  e = window.event
	}
	if (e.preventDefault){
	  e.preventDefault()
	}
	e.returnValue = false;
  }

  // Booststraps Map window
  function load_map(id, lat, lng, zoom) {
	if (GBrowserIsCompatible()) {
	  map = new GMap2(document.getElementById(id));
	  var point = new GLatLng(parseFloat(lat),parseFloat(lng));
	  map.setCenter(point, zoom);
	  map.enableScrollWheelZoom();
	  map.enableContinuousZoom();
	  map.enableDoubleClickZoom();
	  GEvent.addDomListener(map.getContainer(), "DOMMouseScroll", wheelevent);
	  map.getContainer().onmousewheel = wheelevent;
	  map.addControl(new GLargeMapControl());
	 }
	 else {
	   alert("Sorry, the Google Maps API is not compatible with this browser");
	 }
  }

  //]]>
  </script>
</head>
  <body onunload="GUnload()">
	<div id="mymap" class="floatright" style="width: 100%; height: 100%;"></div>
	<div id="path" style="position: absolute; top:501px; width: 100%; height: 10px; overflow:visible"></div>
  </body>
</html>

